# 画面設計書 7-500エラーページ (App Error)

## 概要

App Routerにおいてビルド時に生成される静的500エラーページの設計書。サーバーエラー発生時に表示される静的HTML（500.html）として出力される。

### 本画面の処理概要

**業務上の目的・背景**：本番環境においてサーバーサイドで重大なエラーが発生した場合、動的なエラーレンダリングが不可能な状況でもユーザーにエラー情報を提供する必要がある。本コンポーネントは、`next build`時に静的な500.htmlとして事前生成され、サーバーエラー発生時にフォールバックとして配信される。グローバルエラーページ（No.6）が動的にレンダリングできない場合の最終的な安全ネットとして機能する。

**画面へのアクセス方法**：サーバーエラー（500系エラー）が発生し、動的なエラーページレンダリングが不可能な場合に、Next.jsサーバーが事前生成された500.htmlを返す。

**主要な操作・処理内容**：
1. 「This page failed to load」タイトルを表示する
2. 「Something went wrong while loading this page.」メッセージを表示する
3. 「If this keeps happening, it may be a server issue.」ヒントメッセージを表示する
4. 「Reload page」ボタンを表示し、form submitによりページをリロードする
5. エラーアイコン（ErrorIcon）を表示する
6. ダークモード対応のCSSテーマ変数を適用する

**画面遷移**：
- 遷移元：サーバーエラー発生時にサーバーから配信される
- 遷移先：「Reload page」ボタンでページリロード

**権限による表示制御**：権限による表示制御は行わない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | エラーハンドリング | 主機能 | ビルド時に生成される静的500エラーページの表示処理 |
| 2 | next build | 補助機能 | ビルド時に静的500.htmlとして生成される処理 |

## 画面種別

エラー表示（静的500エラーページ）

## URL/ルーティング

特定のURLパターンは持たない。サーバーエラー発生時のURLのまま500ステータスで静的HTMLが返される。ビルド成果物として`500.html`が出力される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| なし | - | - | - | 本コンポーネントはプロパティを受け取らない（静的ページ） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ページタイトル | titleタグ | 「500: This page failed to load」 |
| エラーアイコン | カード上部 | SVGによるエラーアイコン（ErrorIconコンポーネント） |
| タイトル | h1要素 | 「This page failed to load」 |
| メッセージ | p要素 | 「Something went wrong while loading this page.」 |
| ヒント | p要素 | 「If this keeps happening, it may be a server issue.」 |
| Reload pageボタン | ボタン領域 | form submitによるページリロード |

## イベント仕様

### 1-Reload pageボタン押下

`<form>`タグの`submit`イベントによりページがリロードされる。グローバルエラーページ（No.6）と同様、JavaScriptが無効な環境でもフォームのデフォルト動作で機能する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面はデータベースへのアクセスを行わない |

### テーブル別更新項目詳細

データベース操作なし。

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|----------------|
| TITLE-500 | エラー | 常時表示 | This page failed to load |
| MSG-500 | エラー | 常時表示 | Something went wrong while loading this page. |
| HINT-500 | 情報 | 常時表示 | If this keeps happening, it may be a server issue. |

## 例外処理

| 例外条件 | 挙動 |
|----------|------|
| なし | 本コンポーネントは静的HTMLとして事前生成されるため、ランタイム例外は発生しない |

## 備考

- 本コンポーネントは`next build`時に静的な500.htmlとして生成される
- グローバルエラーページ（No.6）と異なり、`HandleISRError`コンポーネントは含まない
- グローバルエラーページ（No.6）と異なり、「Go back」ボタンやdigest表示は含まない（常にサーバーエラーとして扱う）
- `errorStyles`と`errorThemeCss`はNo.6と共通の`error-styles.tsx`から取得
- html要素に`id="__next_error__"`が設定される
- `'use client'`ディレクティブは設定されていない（静的レンダリング用）
- titleタグがhead内に明示的に設定されている（No.6ではtitleタグが明示的に設定されていない点と異なる）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本コンポーネントはプロパティを受け取らない完全に静的な構成。表示内容はハードコードされている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | error-styles.tsx | `packages/next/src/client/components/builtin/error-styles.tsx` | L3-86: `errorStyles`オブジェクト - 各要素のスタイル定義 |
| 1-2 | error-styles.tsx | `packages/next/src/client/components/builtin/error-styles.tsx` | L88-124: `errorThemeCss` - ダークモード対応CSS変数 |

**読解のコツ**: No.6（グローバルエラーページ）と同じスタイルシステムを使用する。error-styles.tsxを先に理解することで本コンポーネントの見た目を把握できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | app-error.tsx | `packages/next/src/client/components/builtin/app-error.tsx` | L1-36: AppError関数コンポーネント全体 |

**主要処理フロー**:
1. **L1**: `errorStyles`, `errorThemeCss`, `ErrorIcon`をインポート
2. **L6**: `AppError`関数コンポーネントの定義
3. **L8-11**: html/head構造とtitleタグ、errorThemeCssの適用
4. **L14-15**: エラーカードのコンテナとカード要素
5. **L16**: ErrorIconの表示
6. **L17**: h1タイトル「This page failed to load」
7. **L18-20**: メッセージとヒントのp要素
8. **L24-26**: Reload pageボタン（form submit）

#### Step 3: 共通スタイルとアイコンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | error-styles.tsx | `packages/next/src/client/components/builtin/error-styles.tsx` | L126-152: `ErrorIcon`コンポーネント - SVGアイコン |

### プログラム呼び出し階層図

```
next build (ビルドプロセス)
    |
    +-- AppError コンポーネント → 500.html として出力
            |
            +-- <html id="__next_error__">
            +-- <head>
            |       +-- <title> "500: This page failed to load"
            |       +-- errorThemeCss (CSS変数定義)
            |
            +-- <body>
                    +-- エラーカード
                            +-- ErrorIcon (SVG)
                            +-- <h1> "This page failed to load"
                            +-- <p> "Something went wrong..."
                            +-- <p> "If this keeps happening..."
                            +-- <form> Reload page button
```

### データフロー図

```
[入力]               [処理]                           [出力]

(なし) -----------> AppError() -----------------> 静的HTML (500.html)
                    |                              - <html id="__next_error__">
                    +-- errorStyles                - <title> "500: This page..."
                    +-- errorThemeCss              - ErrorIcon (SVG)
                    +-- ErrorIcon                  - エラーメッセージ
                                                   - Reload page ボタン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| app-error.tsx | `packages/next/src/client/components/builtin/app-error.tsx` | ソース | 静的500エラーページのメインコンポーネント |
| error-styles.tsx | `packages/next/src/client/components/builtin/error-styles.tsx` | ソース | エラーページ共通スタイル定義とErrorIconコンポーネント |
